<?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../classi/GeneratoreUrl.php";
    include "../costanti.php";
    include "../util.php";

    session_start();
    if(!isset($_SESSION["geecomUser_email"])) {
        header("Location: index.php");
        exit();
    }
    else {
        $geecomDb = new DbManager($costantiDatabase);
        
        //prendo i valori dalla form
        $nome           = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_MAGIC_QUOTES);
        $cognome        = filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_MAGIC_QUOTES);
        $email          = $geecomDb->escapeString($_POST["email"]);
        $telefono       = $geecomDb->escapeString($_POST["telefono"]);
        $via            = $geecomDb->escapeString($_POST["via"]);
        $citta          = $geecomDb->escapeString($_POST["citta"]);
        $cap            = filter_input(INPUT_POST,"cap",FILTER_SANITIZE_STRING);
        $codiceFiscale  = filter_input(INPUT_POST,"codiceFiscale",FILTER_SANITIZE_STRING);
        $partitaIva     = filter_input(INPUT_POST,"partitaIva",FILTER_SANITIZE_STRING);
        $organizzazione = $geecomDb->escapeString($_POST["organizzazione"]);
        $pec            = filter_input(INPUT_POST,"pec",FILTER_SANITIZE_STRING);
        $codiceInterscambio = filter_input(INPUT_POST,"codiceInterscambio",FILTER_SANITIZE_STRING);
        

        $queryAggiornamentoUtente ="UPDATE geec_utenti SET nome='$nome', cognome='$cognome', telefono='$telefono', organizzazione='$organizzazione', citta = '$citta', cap='$cap', email='$email', descrizione='$descrizione', via='$via', codiceFiscale='$codiceFiscale', partitaIva='$partitaIva', pec='$pec', codiceInterscambio='$codiceInterscambio' WHERE id={$_SESSION["geecomUser_id"]}";
        $geecomDb->eseguiQueryScrittura($queryAggiornamentoUtente);
        
        $impostazioni = recuperaImpostazioni($geecomDb);
        $pagina       = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["paginaProfilo"]);
        $linkPagina   = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        header("Location: $linkPagina&status=100");
    }